/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class Generator
extends JFrame {
    List<Class> classes = new ArrayList<Class>();
    List<Track> tracks = new ArrayList<Track>();
    List<Track> classTracks = new ArrayList<Track>();
    List<Track> racialTracks = new ArrayList<Track>();
    List<Track> extraTracks = new ArrayList<Track>();
    List<Track> multiclassTracks = new ArrayList<Track>();
    List<Track> FBITracks = new ArrayList<Track>();
    List<Track> normalRaces = new ArrayList<Track>();
    static Random random = new Random();
    JCheckBox verbose = new JCheckBox("Verbose");
    boolean verboseChecked;
    JTextArea textArea = new JTextArea();
    int charCount = 0;

    public void initializeClasses() {
        Class barbarian = new Class("Barbarian");
        MultiOptionTrack war = new MultiOptionTrack("Path of War", new String[]{"Path of Rage", "Path of Dervish"});
        Track destruction = new Track("Path of Destruction");
        Track ancestors = new Track("Path of Ancestors");
        barbarian.addTrack(war).addTrack(destruction).addTrack(ancestors);
        this.classes.add(barbarian);
        this.tracks.add(war);
        this.tracks.add(destruction);
        this.tracks.add(ancestors);
        this.classTracks.add(war);
        this.classTracks.add(destruction);
        this.classTracks.add(ancestors);
        Class monk = new Class("Monk");
        Track serpent = new Track("Discipline of the Serpent");
        Track crane = new Track("Discipline of the Crane");
        Track ddragon = new Track("Discipline of the Dragon");
        monk.addTrack(serpent).addTrack(crane).addTrack(ddragon);
        this.classes.add(monk);
        this.tracks.add(serpent);
        this.tracks.add(crane);
        this.tracks.add(ddragon);
        this.classTracks.add(serpent);
        this.classTracks.add(crane);
        this.classTracks.add(ddragon);
        Class paladin = new Class("Paladin");
        Track judgment = new Track("Judgement");
        judgment.setMulticlassable(false);
        MultiOptionTrack paladinOptions = new MultiOptionTrack("Dedication/Oath", new String[]{"Protection", "Heroica", "Smiting", "Virtue"});
        ((Track)paladinOptions).setExclusive(false);
        paladin.addTrack(judgment).addTrack(paladinOptions).addTrack(paladinOptions);
        this.classes.add(paladin);
        this.tracks.add(judgment);
        this.tracks.add(paladinOptions);
        this.tracks.add(paladinOptions);
        this.tracks.add(paladinOptions);
        this.tracks.add(paladinOptions);
        this.classTracks.add(judgment);
        this.classTracks.add(paladinOptions);
        this.classTracks.add(paladinOptions);
        this.classTracks.add(paladinOptions);
        this.classTracks.add(paladinOptions);
        Class ranger = new Class("Ranger");
        Track soldier = new Track("Professional Soldier");
        MultiOptionTrack DandB = new MultiOptionTrack("Daggers  and Bolts", new String[]{"A Reign of Arrows", "Iron Magi"});
        Track tempering = new Track("Battle's Tempering");
        ranger.addTrack(soldier).addTrack(DandB).addTrack(tempering);
        this.classes.add(ranger);
        this.tracks.add(soldier);
        this.tracks.add(DandB);
        this.tracks.add(DandB);
        this.tracks.add(tempering);
        this.classTracks.add(soldier);
        this.classTracks.add(DandB);
        this.classTracks.add(DandB);
        this.classTracks.add(tempering);
        Class rogue = new Class("Rogue");
        Track er = new Track("Esoterica Radica");
        er.setMulticlassable(false);
        MultiOptionTrack offensive = new MultiOptionTrack("Offensive", new String[]{"Assassin", "Swashbuckler", "Demo Man"});
        MultiOptionTrack defensive = new MultiOptionTrack("Defensive", new String[]{"Acrobatic Adept", "I Am Ten Ninjas", "Fortune's Friend"});
        rogue.addTrack(er).addTrack(offensive).addTrack(defensive);
        this.classes.add(rogue);
        this.tracks.add(er);
        this.tracks.add(offensive);
        this.tracks.add(offensive);
        this.tracks.add(offensive);
        this.tracks.add(defensive);
        this.tracks.add(defensive);
        this.tracks.add(defensive);
        this.classTracks.add(er);
        this.classTracks.add(offensive);
        this.classTracks.add(offensive);
        this.classTracks.add(offensive);
        this.classTracks.add(defensive);
        this.classTracks.add(defensive);
        this.classTracks.add(defensive);
        Class sage = new Class("Sage");
        MultiOptionTrack wrath = new MultiOptionTrack("Sage's Wrath", new String[]{"Just Blade", "Arcane Lore"});
        Track will = new Track("Force of Will");
        Track secrets = new Track("Arcane Secrets");
        sage.addTrack(wrath).addTrack(will).addTrack(secrets);
        this.classes.add(sage);
        this.tracks.add(wrath);
        this.tracks.add(wrath);
        this.tracks.add(will);
        this.tracks.add(secrets);
        this.classTracks.add(wrath);
        this.classTracks.add(wrath);
        this.classTracks.add(will);
        this.classTracks.add(secrets);
        Class tactician = new Class("Tactician");
        Track insight = new Track("Tactical Insight");
        Track tricks = new Track("Bag of Tricks");
        Track tspells = new Track("Tactician Spellcasting");
        tactician.addTrack(insight).addTrack(tricks).addTrack(tspells);
        this.classes.add(tactician);
        this.tracks.add(insight);
        this.tracks.add(tricks);
        this.tracks.add(tspells);
        this.classTracks.add(insight);
        this.classTracks.add(tricks);
        this.classTracks.add(tspells);
        Class shaman = new Class("Shaman");
        Track incantation = new Track("Incantation");
        Track sspells = new Track("Shaman Spellcasting");
        this.tracks.add(incantation);
        this.tracks.add(sspells);
        MultiOptionTrack path = new MultiOptionTrack("Shaman's Path", this.tracks);
        path.setMulticlassable(false);
        this.tracks.add(path);
        shaman.addTrack(incantation).addTrack(path).addTrack(sspells);
        this.classes.add(shaman);
        this.classTracks.add(incantation);
        this.classTracks.add(sspells);
        this.classTracks.add(path);
    }

    public void initializeRaces() {
        Track newTrack = new Track("Dragon");
        this.tracks.add(newTrack);
        this.racialTracks.add(newTrack);
        newTrack = new Track("Demon");
        this.tracks.add(newTrack);
        this.racialTracks.add(newTrack);
        newTrack = new MultiOptionTrack("Undead", new String[]{"Ghoul", "Lich", "Mummy", "Vampire", "Skeleton Champion"});
        this.tracks.add(newTrack);
        this.racialTracks.add(newTrack);
        this.tracks.add(newTrack);
        this.racialTracks.add(newTrack);
        this.tracks.add(newTrack);
        this.racialTracks.add(newTrack);
        this.tracks.add(newTrack);
        this.racialTracks.add(newTrack);
        this.tracks.add(newTrack);
        this.racialTracks.add(newTrack);
        newTrack = new Track("Sentient Construct");
        this.tracks.add(newTrack);
        this.racialTracks.add(newTrack);
        newTrack = new Track("Utter Brute");
        this.tracks.add(newTrack);
        this.racialTracks.add(newTrack);
        newTrack = new Track("Unicorn");
        this.tracks.add(newTrack);
        this.racialTracks.add(newTrack);
        newTrack = new Track("Pegasus");
        this.tracks.add(newTrack);
        this.racialTracks.add(newTrack);
        newTrack = new Track("Celestial");
        this.tracks.add(newTrack);
        this.racialTracks.add(newTrack);
        newTrack = new Track("Wildborn");
        this.tracks.add(newTrack);
        this.racialTracks.add(newTrack);
        newTrack = new MultiOptionTrack("Elemental Pony", new String[]{"Fire Elemental", "Water Elemental", "Earth Elemental", "Air Elemental"});
        newTrack.setOverideTitle("Elemental Pony");
        this.tracks.add(newTrack);
        this.racialTracks.add(newTrack);
        this.tracks.add(newTrack);
        this.racialTracks.add(newTrack);
        this.tracks.add(newTrack);
        this.racialTracks.add(newTrack);
        this.tracks.add(newTrack);
        this.racialTracks.add(newTrack);
    }

    public void initializeExtras() {
        Track newTrack = new MultiOptionTrack("Elementalist", new String[]{"Fire Elementalist", "Cold Elementalist", "Electricity Elementalist", "Acid Elementalist"});
        this.tracks.add(newTrack);
        this.extraTracks.add(newTrack);
        newTrack = new Track("Necromancer");
        this.tracks.add(newTrack);
        this.extraTracks.add(newTrack);
        newTrack = new Track("Knight");
        this.tracks.add(newTrack);
        this.extraTracks.add(newTrack);
        newTrack = new Track("Mechanist Savant");
        this.tracks.add(newTrack);
        this.extraTracks.add(newTrack);
        newTrack = new Track("True Mage");
        this.tracks.add(newTrack);
        this.extraTracks.add(newTrack);
        newTrack = new Track("Vigiliante");
        this.tracks.add(newTrack);
        this.extraTracks.add(newTrack);
        newTrack = new Track("Runesong scholar");
        this.tracks.add(newTrack);
        this.extraTracks.add(newTrack);
        newTrack = new Track("Air Elemental");
        this.tracks.add(newTrack);
        this.extraTracks.add(newTrack);
        newTrack = new Track("Fire Elemental");
        this.tracks.add(newTrack);
        this.extraTracks.add(newTrack);
        newTrack = new Track("Earth Elemental");
        this.tracks.add(newTrack);
        this.extraTracks.add(newTrack);
        newTrack = new Track("Water Elemental");
        this.tracks.add(newTrack);
        this.extraTracks.add(newTrack);
        newTrack = new Track("Chirurgic Poet");
        this.tracks.add(newTrack);
        this.extraTracks.add(newTrack);
    }

    public void init() {
        this.initializeRaces();
        this.initializeExtras();
        this.initializeClasses();
        this.initializeMulticlassTracks();
        this.initializeFBITracks();
        this.initializeNormalRaces();
        BorderLayout layout = new BorderLayout();
        this.setLayout(layout);
        JScrollPane scroll = new JScrollPane(this.textArea);
        Dimension d = new Dimension(500, 300);
        scroll.setMinimumSize(d);
        scroll.setMaximumSize(d);
        scroll.setPreferredSize(d);
        this.add((Component)scroll, "Center");
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new GridLayout(2, 2));
        JButton generateButton = new JButton("Generate");
        generateButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                Generator.this.customizeCharacter();
            }
        });
        JButton generateManyButton = new JButton("Generate Many");
        generateManyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                int i = 0;
                while (i < 100) {
                    Generator.this.customizeCharacter();
                    ++i;
                }
            }
        });
        buttonPanel.add(generateButton);
        buttonPanel.add(generateManyButton);
        this.add((Component)buttonPanel, "South");
        buttonPanel.add(this.verbose);
        this.setDefaultCloseOperation(3);
        this.setTitle("Mystify's character build generator");
        this.pack();
        this.setVisible(true);
    }

    private void initializeNormalRaces() {
        Track race = new Track("Human");
        this.normalRaces.add(race);
        race = new Track("Dwarf");
        this.normalRaces.add(race);
        race = new Track("Elf");
        this.normalRaces.add(race);
        race = new Track("Gnome");
        this.normalRaces.add(race);
        race = new Track("Halfling");
        this.normalRaces.add(race);
        race = new Track("Orc");
        this.normalRaces.add(race);
        race = new Track("Earth Pony");
        this.normalRaces.add(race);
        race = new Track("Runed");
        this.normalRaces.add(race);
        race = new Track("Aetherblooded");
        this.normalRaces.add(race);
        race = new Track("Winterkissed");
        this.normalRaces.add(race);
    }

    public void initializeMulticlassTracks() {
        for (Track track : this.classTracks) {
            if (!track.isMulticlassable()) continue;
            this.multiclassTracks.add(track);
        }
        for (Track track : this.extraTracks) {
            if (!track.isMulticlassable()) continue;
            this.multiclassTracks.add(track);
        }
    }

    public void initializeFBITracks() {
        for (Track track : this.multiclassTracks) {
            this.FBITracks.add(track);
        }
        for (Track track : this.racialTracks) {
            if (!track.isMulticlassable()) continue;
            this.FBITracks.add(track);
        }
    }

    public void customizeCharacter() {
        int location;
        boolean placed;
        ++this.charCount;
        Class baseClass = this.classes.get(random.nextInt(this.classes.size()));
        Track[] tracks = new Track[4];
        tracks[0] = Track.copy(baseClass.getTrack(0));
        tracks[1] = Track.copy(baseClass.getTrack(1));
        tracks[2] = Track.copy(baseClass.getTrack(2));
        boolean specialrace = random.nextBoolean();
        boolean multiclassed = random.nextBoolean();
        boolean gi = random.nextBoolean();
        boolean fbi = random.nextBoolean();
        Track racialTrack = null;
        Track multiclassTrack = null;
        Track giTrack = null;
        Track fbiTrack = null;
        String log = "";
        if (specialrace) {
            racialTrack = this.racialTracks.get(random.nextInt(this.racialTracks.size()));
            racialTrack = Track.copy(racialTrack);
            racialTrack.setMulticlassable(false);
            if (this.getVerbose()) {
                log = String.valueOf(log) + " Racial track " + racialTrack.getTitle();
                racialTrack.mark("(r)");
            }
            placed = false;
            while (!placed) {
                location = random.nextInt(3);
                if (!tracks[location].isMulticlassable()) continue;
                tracks[location] = racialTrack;
                placed = true;
            }
        }
        if (multiclassed) {
            multiclassTrack = this.multiclassTracks.get(random.nextInt(this.multiclassTracks.size()));
            while (this.contains(tracks, multiclassTrack)) {
                multiclassTrack = this.multiclassTracks.get(random.nextInt(this.multiclassTracks.size()));
            }
            multiclassTrack = Track.copy(multiclassTrack);
            if (this.getVerbose()) {
                log = String.valueOf(log) + " Multiclass into " + multiclassTrack.getTitle();
            }
            placed = false;
            while (!placed) {
                location = random.nextInt(3);
                if (!tracks[location].isMulticlassable()) continue;
                tracks[location] = multiclassTrack;
                placed = true;
            }
        }
        if (gi) {
            giTrack = this.tracks.get(random.nextInt(this.tracks.size()));
            while (this.contains(tracks, giTrack)) {
                giTrack = this.tracks.get(random.nextInt(this.tracks.size()));
            }
            giTrack = Track.copy(giTrack);
            if (this.getVerbose()) {
                log = String.valueOf(log) + " Guild Initiation into " + giTrack.getTitle();
            }
            placed = false;
            while (!placed) {
                location = random.nextInt(3);
                if (!tracks[location].isMulticlassable()) continue;
                tracks[location] = giTrack;
                placed = true;
            }
        }
        if (fbi) {
            fbiTrack = this.FBITracks.get(random.nextInt(this.FBITracks.size()));
            while (this.contains(tracks, fbiTrack)) {
                fbiTrack = this.FBITracks.get(random.nextInt(this.FBITracks.size()));
            }
            fbiTrack = Track.copy(fbiTrack);
            if (this.getVerbose()) {
                log = String.valueOf(log) + " full buy in for " + fbiTrack.getTitle();
            }
            tracks[3] = fbiTrack;
        } else {
            tracks[3] = new Track("Items");
        }
        if (!specialrace) {
            racialTrack = this.normalRaces.get(random.nextInt(this.normalRaces.size()));
        }
        if (this.getVerbose()) {
            if (multiclassed) {
                multiclassTrack.mark("(mc)");
            }
            if (fbi) {
                fbiTrack.mark("(fbi)");
            }
            if (gi) {
                giTrack.mark("(gi)");
            }
        }
        String[] finalizedTracks = this.finalize(tracks);
        String build = String.valueOf(this.charCount) + ": " + racialTrack.getTitle() + " " + baseClass.getName() + "\n";
        if (this.getVerbose() && log.equals("")) {
            log = "straight";
        }
        build = String.valueOf(build) + finalizedTracks[0];
        build = String.valueOf(build) + "\\" + finalizedTracks[1];
        build = String.valueOf(build) + "\\" + finalizedTracks[2];
        if (fbi) {
            build = String.valueOf(build) + "\\" + finalizedTracks[3];
        }
        build = String.valueOf(build) + "\n";
        this.textArea.append(build);
    }

    private boolean getVerbose() {
        return this.verbose.isSelected();
    }

    private String[] finalize(Track[] tracks2) {
        String[] names = new String[tracks2.length];
        int path = -1;
        int pony = -1;
        int i = 0;
        while (i < tracks2.length) {
            if (tracks2[i].name.equals("Shaman's Path")) {
                path = i;
            } else if (tracks2[i].getTitle().equals("Elemental Pony")) {
                pony = i;
            } else {
                this.fillName(tracks2, i, names);
            }
            ++i;
        }
        if (pony >= 0) {
            this.fillName(tracks2, pony, names);
        }
        if (path >= 0) {
            this.fillName(tracks2, path, names);
        }
        return names;
    }

    public void fillName(Track[] tracks2, int i, String[] names) {
        boolean repeat = false;
        block0: do {
            repeat = false;
            String proposal = tracks2[i].getName();
            int j = 0;
            while (j < i) {
                if (names[j] != null && names[j].equals(proposal)) {
                    repeat = true;
                    continue block0;
                }
                ++j;
            }
            tracks2[i].finalizeName();
            names[i] = proposal;
        } while (repeat);
    }

    private boolean contains(Track[] tracks2, Track multiclassTrack) {
        Track[] trackArray = tracks2;
        int n = tracks2.length;
        int n2 = 0;
        while (n2 < n) {
            Track track2 = trackArray[n2];
            if (track2 != null && track2.equals(multiclassTrack) && multiclassTrack.isMutuallyExclusive()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static void main(String[] args) {
        Generator generator = new Generator();
        generator.init();
    }
}

