/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Random;

public class MultiOptionTrack
extends Track {
    List<Track> options = new ArrayList<Track>();
    static Random random = new Random();
    boolean exclusive = true;
    String finalName;
    boolean nameFinalized;

    public MultiOptionTrack(String name) {
        super(name);
        this.options.add(new Track(name));
    }

    public MultiOptionTrack(String name, String[] names) {
        super(name);
        String[] stringArray = names;
        int n = names.length;
        int n2 = 0;
        while (n2 < n) {
            String thisName = stringArray[n2];
            this.options.add(new Track(thisName));
            ++n2;
        }
    }

    public MultiOptionTrack(String name, Track[] tracks) {
        super(name);
        Track[] trackArray = tracks;
        int n = tracks.length;
        int n2 = 0;
        while (n2 < n) {
            Track track = trackArray[n2];
            this.options.add(track);
            ++n2;
        }
    }

    public MultiOptionTrack(String name, Collection<Track> tracks) {
        super(name);
        for (Track track : tracks) {
            if (!track.isMulticlassable()) continue;
            this.options.add(track);
        }
    }

    public MultiOptionTrack(MultiOptionTrack track) {
        super(track);
        this.options = track.options;
        this.exclusive = track.exclusive;
    }

    @Override
    public void setExclusive(boolean ex) {
        this.exclusive = ex;
    }

    @Override
    public String getName() {
        if (!this.nameFinalized) {
            this.finalName = this.options.get(random.nextInt(this.options.size())).getName();
        }
        return String.valueOf(this.finalName) + this.tag;
    }

    @Override
    public boolean isMutuallyExclusive() {
        return this.exclusive;
    }

    @Override
    public void finalizeName() {
        this.nameFinalized = true;
    }

    @Override
    public void unfinalizeName() {
        this.nameFinalized = false;
    }
}

